﻿// ---------------------------------------------------------------
// <copyright file="ChromeHostFormList.cs" company="B33Rbaron">
//     Copyright (c) Daniel Birler.
//     Licensed under Microsoft Public License (Ms-PL).
// </copyright>
// <author>Daniel Birler</author>
// ---------------------------------------------------------------

namespace ChromeHost
{
  using System;
  using System.Collections.Generic;

  /// <summary>
  /// A List for ChromeHostForms.
  /// </summary>
  public sealed class ChromeHostFormList : List<ChromeHostForm>
  {
    /// <summary>
    /// Adds a ChromeHostForm to the List from a window handle.
    /// </summary>
    /// <param name="windowHandle">The window handle to create a ChromeHostForm for.</param>
    /// <returns>The added ChromeHostForm.</returns>
    public ChromeHostForm AddFromWindowHandle(IntPtr windowHandle)
    {
      ChromeHostForm chromeHostForm = new ChromeHostForm(windowHandle);
      this.Add(chromeHostForm);

      return chromeHostForm;
    }

    /// <summary>
    /// Finds a ChromeHostForm in the List from a window handle.
    /// </summary>
    /// <param name="windowHandle">The window handle associated with the form to search for.</param>
    /// <returns>The found ChromeHostForm or otherwise null.</returns>
    public ChromeHostForm FindFromWindowHandle(IntPtr windowHandle)
    {
      return this.Find(delegate(ChromeHostForm chromeHostForm) { return chromeHostForm.Handle == windowHandle; });
    }

    /// <summary>
    /// Moves an already added ChromeHostForm to the first position in the list.
    /// </summary>
    /// <param name="chromeHostForm">The ChromeHostForm to move.</param>
    public void MoveToFirstPosition(ChromeHostForm chromeHostForm)
    {
      this.Remove(chromeHostForm);
      this.Insert(0, chromeHostForm);
    }
  }
}