﻿// ---------------------------------------------------------------
// <copyright file="AboutForm.cs" company="B33Rbaron">
//     Copyright (c) Daniel Birler.
//     Licensed under Microsoft Public License (Ms-PL).
// </copyright>
// <author>Daniel Birler</author>
// ---------------------------------------------------------------

namespace ChromeHost
{
  using System;
  using System.Diagnostics;
  using System.Globalization;
  using System.IO;
  using System.Windows.Forms;
  using ChromeHost.Properties;

  /// <summary>
  /// An about form.
  /// </summary>
  public sealed partial class AboutForm : Form
  {
    /// <summary>
    /// The name of the license file.
    /// </summary>
    private const string ChromeHostLicense = "ChromeHostLicense.txt";

    /// <summary>
    /// Initializes a new instance of the AboutForm class.
    /// </summary>
    public AboutForm()
    {
      this.InitializeComponent();
    }

    /// <summary>
    /// Starts a process from a given url.
    /// </summary>
    /// <param name="url">The url to start.</param>
    private void StartProcess(Uri url)
    {
      using (Process process = Process.Start(url.OriginalString))
      {
      }
    }

    /// <summary>
    /// Occurs when the link label for the license is clicked.
    /// </summary>
    /// <param name="sender">The source of the event.</param>
    /// <param name="e">A System.Windows.Forms.LinkLabelLinkClickedEventArgs that contains event data.</param>
    private void LicenseClicked(object sender, LinkLabelLinkClickedEventArgs e)
    {
      string licenseFullPath = string.Format(CultureInfo.InvariantCulture, "{0}{1}", Path.GetTempPath(), AboutForm.ChromeHostLicense);
      File.WriteAllText(licenseFullPath, Resources.ChromeHostLicense);
      this.StartProcess(new Uri(licenseFullPath));
    }

    /// <summary>
    /// Occurs when the link label for the web page is clicked.
    /// </summary>
    /// <param name="sender">The source of the event.</param>
    /// <param name="e">A System.Windows.Forms.LinkLabelLinkClickedEventArgs that contains event data.</param>
    private void ChromeHostLinkClicked(object sender, LinkLabelLinkClickedEventArgs e)
    {
      this.StartProcess(new Uri("http://www.schbaem.de/chromehost"));
    }

    /// <summary>
    /// Occurs when the Info Button is clicked.
    /// </summary>
    /// <param name="sender">The source of the event.</param>
    /// <param name="e">A System.EventArgs that contains the event data.</param>
    private void InfoClicked(object sender, EventArgs e)
    {
      FormManager.Instance.ShowInfoForm();
    }

    /// <summary>
    /// Occurs when the Ok Button is clicked.
    /// </summary>
    /// <param name="sender">The source of the event.</param>
    /// <param name="e">A System.EventArgs that contains the event data.</param>
    private void OkClicked(object sender, EventArgs e)
    {
      this.Close();
    }
  }
}