﻿// ---------------------------------------------------------------
// <copyright file="NameUrlPair.cs" company="B33Rbaron">
//     Copyright (c) Daniel Birler.
//     Licensed under Microsoft Public License (Ms-PL).
// </copyright>
// <author>Daniel Birler</author>
// ---------------------------------------------------------------

namespace ChromeHost
{
  using System;

  /// <summary>
  /// A class representing a name-url pair.
  /// </summary>
  public sealed class NameUrlPair
  {
    /// <summary>
    /// The name.
    /// </summary>
    private string name = string.Empty;

    /// <summary>
    /// The url.
    /// </summary>
    private Uri url = null;

    /// <summary>
    /// Initializes a new instance of the NameUrlPair class.
    /// </summary>
    /// <param name="name">The name.</param>
    /// <param name="url">The url.</param>
    public NameUrlPair(string name, Uri url)
    {
      this.name = name;
      this.url = url;
    }

    /// <summary>
    /// Gets or sets the name.
    /// </summary>
    public string Name
    {
      get { return this.name; }
      set { this.name = value; }
    }

    /// <summary>
    /// Gets or sets the url.
    /// </summary>
    public Uri Url
    {
      get { return this.url; }
      set { this.url = value; }
    }
  }
}